﻿var panelImportation = {
    pageTables: {},
    context: $(".panelValidateImport"),
    initializeGrid: function (table, ajaxSource, status, isPanelDuplicates, totalSpan) {
        var toolBarItems;
        var contextMenuItems;

        if (isPanelDuplicates) {
            toolBarItems = [
                { "Action": "AcceptedAsNew", "Label": pageTexts.AcceptAsNew },
                { "Action": "AcceptedAsMerge", "Label": pageTexts.AcceptAsMerge },
                { "Action": "Ignored", "Label": pageTexts.Ignore },
                { "Action": "AcceptedAllAsNew", "Label": pageTexts.AcceptAllAsNew, "DisplayMode": dataTables.itemDisplayMode.nonSelected },
                { "Action": "AcceptedAllAsMerge", "Label": pageTexts.AcceptAllAsMerge, "DisplayMode": dataTables.itemDisplayMode.nonSelected },
                { "Action": "IgnoredAll", "Label": pageTexts.IgnoreAll, "DisplayMode": dataTables.itemDisplayMode.nonSelected }
            ];

            contextMenuItems = [
                { "Action": "AcceptedAsNew", "Label": pageTexts.AcceptAsNew },
                { "Action": "AcceptedAsMerge", "Label": pageTexts.AcceptAsMerge },
                { "Action": "Ignored", "Label": pageTexts.Ignore },
            ];
        }
        else {
            toolBarItems = [
                { "Action": "Accepted", "Label": pageTexts.Accept },
                { "Action": "Ignored", "Label": pageTexts.Ignore },
                { "Action": "AcceptedAll", "Label": pageTexts.AcceptAll, "DisplayMode": dataTables.itemDisplayMode.nonSelected },
                { "Action": "IgnoredAll", "Label": pageTexts.IgnoreAll, "DisplayMode": dataTables.itemDisplayMode.nonSelected }
            ];

            contextMenuItems = [
                { "Action": "Accepted", "Label": pageTexts.Accept },
                { "Action": "Ignored", "Label": pageTexts.Ignore },
            ];
        }

        table.a4datatable({
            ajaxAction: a4.getAction(ajaxSource, "Import", "Panel"),
            ajaxParams: { "importationId": importationId },
            columns: [
                {
                    "Data": function (rowData) {
                        var defer = $.Deferred();
                        a4.callServerMethod(a4.getAction("GetErrorsTooltip", "Import", "Panel"), { panelistId: rowData.Id }, function (result) {
                            defer.resolve(result);
                        });
                        return defer.promise();
                    },
                    "Tooltip": true
                },
                { "Name": "Email", "Title": resources.Email, "Data": "Email", "Width": "27%" },
                { "Name": "FirstName", "Title": resources.FirstName, "Data": "FirstName", "Width": "27%" },
                { "Name": "LastName", "Title": resources.LastName, "Data": "LastName", "Width": "27%" },
                { "Name": "Resolution", "Title": resources.Status, "Data": "ResolutionName", "Width": "19%" }
            ],
            toolBarItems: toolBarItems,
            toolBarClick: function (event, data) {
                var action = data.action;
                var rows = data.rows;

                if (action.indexOf("All") == -1) {
                    panelImportation.updatePanelistsResolution("UpdatePanelistsResolution", { panelistIds: _.pluck(rows, "Id"), resolution: action });
                }
                else {
                    modalDialog.showConfirmDialog(confirmUpdatePanelistsResources, function () {
                        panelImportation.updatePanelistsResolution("UpdateAllPanelistsResolution", { status: status, resolution: action, importationId: importationId });
                    }, 220, 500, false, { "count": table.a4datatable("getTotalRecords"), "status": confimUpdatePanelistsLabels[status], "action": confimUpdatePanelistsLabels[action] });
                }
            },
            contextMenuItems: contextMenuItems,
            contextMenuClick: function (event, data) {
                var action = data.action;
                var row = data.row;

                panelImportation.updatePanelistsResolution("UpdatePanelistResolution", { panelistId: row.Id, resolution: action });
            },
            draw: function () {
                totalSpan.text($(this).a4datatable("getTotalRecords"));
            }
        });
    },
    bindPageOptionsHeaderEvents: function () {
        $("#main-header .v-commitButton", panelImportation.context).on("click", function () {
            modalDialog.showConfirmDialog(confirmCommitImportationResources, function () {
                a4.callServerMethod(a4.getAction("CommitImportation", "Import", "Panel"), { importationId: importationId }, function (result) {
                    window.location.href = a4.getAction("Index", "Import", "Panel");
                });
            }, 220, 500, false, {});
        });
    },
    bindShowMoreDetailsEvent: function () {
        $(".dataTables_wrapper").on("click", "div .moreDetails", function () {
            var panelistId = $(this).attr("data-panelistid");
            modalDialog.showWindow(a4.getAction("DuplicatePanelistDetails", "Import", "Panel", { panelistId: panelistId }), 580, 700);
        });
    },
    updatePanelistsResolution: function (method, parameters) {
        a4.callServerMethod(a4.getAction(method, "Import", "Panel"), parameters, function (result) {
            panelImportation.refreshGrids(result);
        });
    },
    refreshGrids: function (validated) {
        if (validated) {
            a4.callServerMethod(a4.getAction("GetImportData", "Import", "Panel"), { importationId: importationId }, function (result) {
                var importData = result;
                var commitButton = $("#main-header .v-commitButton", panelImportation.context);

                if (importData.ModifiedBy) {
                    $(".panelValidateImport .importModifiedBy").text(importData.ModifiedBy);
                }

                $(".panelValidateImport .importModifiedOn").text(importData.ModifiedOn);
                $(".panelValidateImport .importStatus").text(importData.StatusName);
                commitButton.css('display', 'inline');
            });
        }

        panelImportation.pageTables.importedWithErrors.a4datatable("refresh");
        panelImportation.pageTables.fileDuplicates.a4datatable("refresh");
        panelImportation.pageTables.panelDuplicates.a4datatable("refresh");
    }
}

$(document).ready(function () {
    $(".panelValidateImport .importedWithoutErrorTable").a4datatable({
        ajaxAction: a4.getAction("GetImportedWithoutError", "Import", "Panel"),
        ajaxParams: { "importationId": importationId },
        columns: [
            { "Name": "Email", "Title": resources.Email, "Data": "Email", "Width": "40%" },
            { "Name": "FirstName", "Title": resources.FirstName, "Data": "FirstName", "Width": "30%" },
            { "Name": "LastName", "Title": resources.LastName, "Data": "LastName", "Width": "30%" }
        ],
        draw: function () {
            $(".importedWithoutErrorTotal").text($(this).a4datatable("getTotalRecords"));
        }
    });

    panelImportation.pageTables.importedWithErrors = $(".panelValidateImport .importedWithErrorsTable");
    panelImportation.initializeGrid(panelImportation.pageTables.importedWithErrors, "GetImportedWithErrors", "Error", false, $(".importedWithErrorsTotal"));

    panelImportation.pageTables.fileDuplicates = $(".panelValidateImport .fileDuplicatesTable");
    panelImportation.initializeGrid(panelImportation.pageTables.fileDuplicates, "GetFileDuplicates", "FileDuplicate", false, $(".fileDuplicatesTotal"));

    panelImportation.pageTables.panelDuplicates = $(".panelValidateImport .panelDuplicatesTable");
    panelImportation.initializeGrid(panelImportation.pageTables.panelDuplicates, "GetPanelDuplicates", "PanelDuplicate", true, $(".panelDuplicatesTotal"));

    panelImportation.bindPageOptionsHeaderEvents();
    panelImportation.bindShowMoreDetailsEvent();
});